
PROGRAM ID;

{ --------------------------------------------------------------------------- }
{                                                                             }
{ DEMO PROGRAM ID                                                             }
{ EXAMPLE                                                                     }
{ TRANSMIT AND RECEIVE DATA                                                   }
{ TRANSMIT = IWD; RECEIVE =  IRD                                              }
{                                                                             }
{ UNIT H080_1                                                                 }
{ Supports the compiler with the required procedures                          }
{ The HO80 card address is checked automatically by the program               }
{ Common variables are defined in unit HO80_1 (see HO80_1.DOC)                }
{                                                                             }
{ --------------------------------------------------------------------------- }

USES
  CRT,
  HO80_1;


  BEGIN   { IEEEPAS1 }
  IF not IEEE_card then HALT;           { terminate if HO80 not present       }

  Adress := 21;                         { HO80 address                        }
  Pegel  := 0;                          { system controller                   }
  INIT (Adress, Pegel);                 { activate interface                  }

  delay (3000);

  Instrument := $B;                     { device address                      }

  Befehl := 'ID?';

  IWD (Instrument, Befehl, Status);     { transmit command to interface       }
  writeln (' status : ',status);

  Befehl := '              ';
  IRD (Befehl, Instrument, Status);     { read data                           }

  writeln (Befehl);                     { display data                        }
  END.    { IEEEPAS1 }
